/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.structure;

import ivorius.reccomplex..shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex..shadow.mcopts.translation.ServerTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandListStructures
extends CommandExpecting {
    public static final int RESULTS_PER_PAGE = 20;

    public static void showList(ICommandSender commandSender, int page, List<String> structureNames) {
        int startIndex = page * 20;
        int endIndex = Math.min((page + 1) * 20, structureNames.size());
        if (endIndex - startIndex > 0) {
            ArrayList<Object> components = new ArrayList<Object>(endIndex - startIndex + 2);
            components.add(new TextComponentString("[<--]"));
            if (page > 0) {
                CommandListStructures.linkToPage((ITextComponent)components.get(0), page - 1, RecurrentComplex.translations.format("commands.rclist.previous", new Object[0]));
            }
            for (int i = 0; i < endIndex - startIndex; ++i) {
                components.add(RCTextStyle.structure(structureNames.get(startIndex + i)));
            }
            components.add(new TextComponentString("[-->]"));
            if (page < (structureNames.size() - 1) / 20) {
                CommandListStructures.linkToPage((ITextComponent)components.get(components.size() - 1), page + 1, RecurrentComplex.translations.format("commands.rclist.next", new Object[0]));
            }
            commandSender.func_145747_a((ITextComponent)ServerTranslations.join(components));
        } else {
            commandSender.func_145747_a(RecurrentComplex.translations.get("commands.rclist.none"));
        }
    }

    public static void linkToPage(ITextComponent component, int page, ITextComponent hoverTitle) {
        component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s", RCCommands.structures.list(page))));
        component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverTitle));
        component.func_150256_b().func_150238_a(TextFormatting.AQUA);
    }

    public String func_71517_b() {
        return "list";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void expect(Expect expect) {
        expect.any(0).descriptionU("page");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        int page = parameters.get(0).to(NaP::asInt).optional().orElse(0);
        ArrayList<String> structureNames = new ArrayList<String>();
        structureNames.addAll(StructureRegistry.INSTANCE.ids());
        structureNames.sort(String.CASE_INSENSITIVE_ORDER);
        CommandListStructures.showList(commandSender, page, structureNames);
    }
}

